/***************************************************************************
                          rpmitem.cpp  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rpmitem.h"

#include <qspinbox.h>
#include <kiconloader.h>
#include "integerdialog.h"

RPMItem::RPMItem(GroupManager * g, GroupViewWidget * gv) : GroupItem(g,gv){
	setType(TYPE_RPM);
	KIconLoader l;
	topItem() -> setText(0,"RPM");
	QString s;
	s.setNum(groupManager() -> rpmSafetyLevel());
	topItem() -> setText(6,s);
	topItem() -> setPixmap(0,l.loadIcon("rpm", KIcon::Small));	
}

RPMItem::~RPMItem(){
}

void RPMItem::slotItemClicked(QListViewItem * i, const QPoint &p, int c){
	groupManager() -> init(TYPE_RPM);
	if (i != 0){
		if (i == topItem()){
			switch (c){
				case 0:
			    topItem() -> setOpen(!topItem() -> isOpen());
					if (groupManager() -> count(TYPE_RPM) == 0)
						groupManager() -> update(TYPE_RPM);
						break;
				case 6:
					IntegerDialog * d = new IntegerDialog();
					d -> SpinBox1 -> setValue(groupManager() -> rpmSafetyLevel());
					int i = d -> exec();
					if (i>=0){
						groupManager() -> setRPMSafetyLevel((unsigned int)i);
						deleteChilderen();
						groupManager() -> clear(TYPE_RPM);
					}
					break;
			}
		}
		if (i -> parent() == topItem()){
			switch (c){
				case 0:
					emit setupFileList(groupManager() -> rpm(name(i)));
					emit setProperties(groupManager() -> rpm(name(i)));
					groupManager() -> rpm(name(i)) -> clearMem();
					break;
				case 1:
					RPM * r = groupManager() -> rpm(name(i));
					r -> setMarked(!r -> isMarked());
					if (r -> isMarked()){
						KIconLoader icnl;
						i -> setPixmap(1,QPixmap(icnl.loadIcon("flag",KIcon::Small)));
					}
					else
						i -> setPixmap(1,QPixmap());
					rpmToItem(r,i);
			}
		}
	}
}

void RPMItem::slotUpdateReady(){
	deleteChilderen();
	for (unsigned int i = 0; i < groupManager() -> count(TYPE_RPM); i++)
		rpmToItem(groupManager() -> rpm(i), new QListViewItem(topItem()));
	topItem() -> setOpen(true);
}

void RPMItem::rpmToItem(RPM * r, QListViewItem * i){
	groupToItem(r,i);
	KIconLoader icnl;
	i -> setPixmap(0,icnl.loadIcon("rpm", KIcon::Small));
	i -> setText(6,"");
}

