/***************************************************************************
                          cleanupwizard.cpp  -  description
                             -------------------
    begin                : Wed Feb 7 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@wanadoo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qradiobutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qprogressbar.h>

#include <kfiledialog.h>
#include <klocale.h>

#include "cleanupwizard.h"
#include "info.h"

CleanupWizard::CleanupWizard(FileGroupExt * f){
	fileGroup = f;
	batch = new Batch(true);
	logView = 0;
	LineEdit1 -> setText(defaultArchiveDir());
	LineEdit2 -> setText(defaultArchiveDir());
	LineEdit3 -> setText(getenv("HOME"));
	t = title(page); t_2 = title(page_2); t_3 = title(page_3); t_4 = title(page_4);	t_5 = title(page_5); t_6 = title(page_6);
	slotDelete();
}

CleanupWizard::~CleanupWizard(){
	if (batch){}
		delete batch;
	if (logView)
		delete logView;
}

void CleanupWizard::slotDelete(){
	initPages();
	removePage(page_3);
	removePage(page_4);
	removePage(page_6);
	setInfo("deleted");
}

void CleanupWizard::slotArchive(){
	initPages();
	removePage(page_2);
	removePage(page_4);
	removePage(page_6);
	setInfo("archived");
}

void CleanupWizard::slotMove(){
	initPages();
	removePage(page_2);
	removePage(page_3);
	removePage(page_6);
	setInfo("moved");
}

void CleanupWizard::setInfo(QString s){
  QString n_1,n_2;
  n_1.setNum(fileGroup -> numMarked());
  n_2.setNum(fileGroup -> sizeMarked());
  TextLabel1 -> setText(i18n("A total of " + n_1 + " files will be " + s + " containing " + n_2 + " bytes"));
	setFinishEnabled(page_5,true);
}

void CleanupWizard::slotBrowseBackup(){
	LineEdit1 -> setText(KFileDialog::getExistingDirectory(getenv("HOME")));
}

void CleanupWizard::slotBrowseArchive(){
}

void CleanupWizard::slotBrowseMove(){
}

void CleanupWizard::slotCleanUpCompleted(){
	delete progress;
	if (batch){
		system(fileGroup -> command());
		logView = new LogViewWidget(batch -> procList);
		addPage(page_6,t_6);
		setBackEnabled(page_6,false);
		setNextEnabled(page_6,false);
		showPage(page_6);
		if (batch -> error())
			TextLabel4 -> setText(i18n("Errors occured! See log for more information"));
		else
			TextLabel4 -> setText(i18n("The cleaning ended succesfully."));
	}
	cancelButton() -> setText(i18n("Close"));
}

void CleanupWizard::accept(){
	progress = new ButtonLabelWidget3();
	progress -> show();
	progress -> ProgressBar1 -> setTotalSteps(fileGroup -> numMarked());
	connect (progress -> PushButton1, SIGNAL(clicked()), SLOT(slotCancel()));
	if (RadioButton1 -> isChecked() & RadioButton4 -> isChecked()){
		progress -> TextLabel1 -> setText(i18n("Backup & Delete Files"));
		proc = fileGroup -> archive(fileGroup -> nextArchiveFileName(LineEdit1 -> text()),fileGroup -> archiveRoot(),false);
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		batch -> append(proc, fileGroup);
		proc = fileGroup -> remove();
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		batch -> append(proc, fileGroup );
		connect(batch, SIGNAL(batchExited()),SLOT(slotCleanUpCompleted()));
		batch -> start();
	}
	if (RadioButton1 -> isChecked() & RadioButton5 -> isChecked()){
		progress -> TextLabel1 -> setText(i18n("Delete Files"));
		proc = fileGroup -> remove();
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		batch -> append(proc, fileGroup );
		connect(batch, SIGNAL(batchExited()),SLOT(slotCleanUpCompleted()));
		batch -> start();
	}
	if (RadioButton2 -> isChecked()){
		progress -> TextLabel1 -> setText(i18n("Archive Files"));
		proc = fileGroup -> archive(fileGroup -> nextArchiveFileName(LineEdit2 -> text()), fileGroup -> archiveRoot(),true);
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		batch -> append(proc, fileGroup );
		connect(batch, SIGNAL(batchExited()),SLOT(slotCleanUpCompleted()));
		batch -> start();
	}
	if (RadioButton3 -> isChecked()){
		progress -> TextLabel1 -> setText(i18n("Move Files"));
		proc = fileGroup -> move(LineEdit3 -> text());
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		batch -> append(proc, fileGroup );
		connect(batch, SIGNAL(batchExited()),SLOT(slotCleanUpCompleted()));
		batch -> start();
	}
}

void CleanupWizard::initPages(){
	removePage(page);
	removePage(page_2);
	removePage(page_3);
	removePage(page_4);
	removePage(page_5);
	removePage(page_6);
	addPage(page,t);
	addPage(page_2, t_2);
	addPage(page_3, t_3);
	addPage(page_4, t_4);
	addPage(page_5, t_5);
	addPage(page_6, t_6);
}

