/***************************************************************************
                          filegroupbase.cpp  -  description
                             -------------------
    begin                : Thu Jan 6 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <qregexp.h>
#include <qtextstream.h>
#include "filegroupbase.h"
#include "helperfunctions.h"

FileGroupBase::FileGroupBase(){
	fileList = new QStrList();
	fileList -> setAutoDelete(true);
	fileMarkList = new QList<bool>();
	fileMarkList -> setAutoDelete(true);
	dirList = new QStrList();
	dirList -> setAutoDelete(true);
	dirMarkList = new QList<bool>();
	dirMarkList -> setAutoDelete(true);
	permanent = new QStrList();
	permanent -> setAutoDelete(true);
	setName("");
	setDescription("");
	setSafetyLevel(0);
	setAutoCleanUp(false);
	setIcon("");
	totsize = 0;
	setMarked(false);
	nf = nd = 0;
}

FileGroupBase::~FileGroupBase(){
	delete fileList;
	delete fileMarkList;
	delete dirList;
	delete dirMarkList;
	delete permanent;
}

void FileGroupBase::addFile(QString s){
	condLoad();
	expandTilde(s);
	QFileInfo f(s);
	if (f.isFile() && !containsFile(s)){
		fileList -> append(s);
		bool * b = new bool;
		fileMarkList -> append(b);
		*fileMarkList -> current() = false;
		totsize+= f.size();
		nf++;
	}
	else if (f.isDir())
		addDir(s);
}

void FileGroupBase::addDir(QString s){
	condLoad();
	expandTilde(s);
	QFileInfo f(s);
	if (f.isDir() && !containsDir(s)){
		dirList -> append(s);
		bool * b = new bool;
		dirMarkList -> append(b);
		*dirMarkList -> current() = false;
		nd++;
	}
}

void FileGroupBase::removeFile(unsigned int i){
	condLoad();
	QString s(file(i));
	QFileInfo f(s);
	fileList -> remove(i);
	fileMarkList -> remove(i);
	totsize-= f.size();
	nf--;
}

bool FileGroupBase::containsFile(QString s){
	bool r = false;
	for (unsigned int i = 0; i < numFiles(); i++)
    if (file(i) == s)
			r = true;
	return r;
}

bool FileGroupBase::containsDir(QString s){
	bool r = false;
	for (unsigned int i = 0; i < numDirs(); i++)
    if (dir(i) == s)
			r = true;
	return r;
}

QString FileGroupBase::description(){
	return descr;
}

void FileGroupBase::setDescription(QString s){
	descr = s;
}

void FileGroupBase::addPermanentFiles(){
	for (unsigned int i = 0; i < permanent -> count(); i++){
		QString s(permanent -> at(i));
		addFile(permanent -> at(i));
	}
}	
	
unsigned int FileGroupBase::totalSize(){
	unsigned int sum = 0;
	for (unsigned int i = 0; i < numFiles(); i++){
		QFileInfo fi(file(i));
		sum += fi.size();
	}
	return sum;
}

unsigned int FileGroupBase::sizeGreen(){
	unsigned int sum = 0;
	for (unsigned int i = 0; i < numFiles(); i++){
		QFileInfo fi(file(i));
		if (isSafe(file(i)))
			sum += fi.size();
	}
	return sum;
}

bool FileGroupBase::isSafe(const QString s){
	bool b;
	QDateTime current_date_time = QDateTime::currentDateTime();
	QFileInfo fi(s);
	QDateTime dat(fi.lastRead());
	unsigned int t = dat.secsTo(current_date_time)/(86400);
	if (t < safetyLevel())
		b = false;
	else
		b = true;
	return b;
}

unsigned int FileGroupBase::numMarked(){
	unsigned int r = 0;
	for (unsigned int i = 0; i < fileMarkList -> count(); i++)
		if (fileMark(i) == true)
			r++;
	return r;
}

unsigned int FileGroupBase::sizeMarked(){
	unsigned int sum = 0;
	for (unsigned int i = 0; i < numFiles(); i++)
		if (fileMark(i) == true)		{
			QFileInfo fi(file(i));
			sum += fi.size();
		}
	return sum;
}

void FileGroupBase::markAll(){
	for (unsigned int i = 0; i < numFiles(); i++)
		setFileMark(i, true);
}

void FileGroupBase::unMarkAll(){
	for (unsigned int i = 0; i < numFiles(); i++)
		setFileMark(i, false);
}

void FileGroupBase::markGreen(){
	for (unsigned int i = 0; i < numFiles(); i++){
		if (isSafe(file(i)))
			setFileMark(i, true);
		else
			setFileMark(i, false);
	}
}

unsigned int FileGroupBase::numGreen(){
	unsigned int s = 0;
	for (unsigned int i = 0; i < numFiles(); i++)
		if (isSafe(file(i)))
			s++;
	return s;
}

QString FileGroupBase::info(infotag i){
	QString b;
	switch (i){
		case INFO_NAME :
			b = name();
			break;
		case INFO_DESCRIPTION :
			b = description();
			break;
	}
	return b;
}

/*QString FileGroupBase::info(infotag i){
	QString s="";
	return s;
}*/

unsigned int  FileGroupBase::file(QString s){
	condLoad();
	return fileList -> find(s);
}

QString FileGroupBase::file(uint i){
	condLoad();
	return fileList -> at(i);
}

unsigned int  FileGroupBase::dir(QString s){
	condLoad();
	return dirList -> find(s);
}

QString FileGroupBase::dir(uint i){
	condLoad();
	return dirList -> at(i);
}

void FileGroupBase::condLoad(){
	if (numFiles() != fileList -> count())
		loadFiles();
}

void FileGroupBase::clearMem(){
	fileList -> clear();
	fileMarkList -> clear();
}

bool FileGroupBase::fileMark(unsigned int i){
	condLoad();
	return *fileMarkList -> at(i);
}

void FileGroupBase::setFileMark(unsigned int i, bool b){
	condLoad();
	*fileMarkList -> at(i) = b;
}

void FileGroupBase::unloadFiles(){
	nf = 0;
	fileList -> clear();
	fileMarkList -> clear();
}

void FileGroupBase::addFileFast(QString s){
	expandTilde(s);
	fileList -> append(s);
	bool * b = new bool;
	fileMarkList -> append(b);
	*fileMarkList -> current() = false;
	nf++;
}

void FileGroupBase::sync(){
	addPermanentFiles();
	//remove nonexsitent files
	unsigned int i = 0;
	while (i < numFiles()){
		QFileInfo fi(file(i));
		if (!fi.exists())
			removeFile(i);
		else
			i++;
	}
	//remove double files
	fileList -> sort();
	fileList -> first();
	while (fileList -> current() != 0){
		QString s = fileList -> current();
		QString s2 = fileList -> next();
		if (s == s2){
			fileList -> prev();
			fileList -> remove();
		}
	}
	//set some variables and fileMarkList
	fileMarkList -> clear();
	nf = 0;
	totsize = 0;
	for (unsigned int i = 0; i < fileList -> count(); i++){ //don't use numFiles() here (nf == 0)
		bool * b = new bool;
		fileMarkList -> append(b);
		*fileMarkList -> current() = false;
		QFileInfo fi(fileList -> at(i));   //don't use file(i) here
		totsize+= fi.size();
		nf++;
	}

}

