/***************************************************************************
                          groupviewwidget.h  -  description
                             -------------------
    begin                : Wed Nov 8 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GROUPVIEWWIDGET_H
#define GROUPVIEWWIDGET_H

#include <kmainwindow.h>
#include <klocale.h>
#include "filegroupext.h"
#include "rpm.h"
#include "cleanupwizard.h"
#include "groupviewbase.h"
#include "grouptree.h"
#include "filelistview.h"
#include "ablabel.h"
#include "rpmtree.h"
#include "udgtree.h"
#include "instree.h"

/**
  *@author Arjan Buursink
  */

class GroupViewWidget : public GroupViewBase {
   Q_OBJECT
public:
	GroupViewWidget(QWidget *parent=0, const char *name=0);
	~GroupViewWidget();
	RPMTree * rpmTree;
	UDGTree * udgTree;
	INSTree * insTree;
private:
	grouptype groupType() { return gt;};
	void hide();
	void installDefaultGroups();
	CleanupWizard * cleanupWizard;
	grouptype	gt;
	bool isGroupType(grouptype);
	QTabWidget * tab;
//	KHTMLPart * properties;
	QWidget * filesTab;
	void setGroupType(grouptype t){	gt = t;};
private slots:
//	void slotUpdateUDG();
	void slotCleanup();
	void slotClose(){delete this;};
	void slotSetupFileList(FileGroupBase *);
	void slotSelectAll();
	void slotDeSelectAll();
	void slotFileSelectionChanged(FileGroupBase *);
	void slotHelp();
	void slotView();
	void slotSelectionChanged();
	void slotSetProperties(FileGroupBase *);
	void slotSetStatus(QString);
signals:
	void cleanup(FileGroupExt*);
};

#endif

