/***************************************************************************
                          udg.cpp  -  description
                             -------------------
    begin                : Thu Dec 23 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "udg.h"
#include <stdlib.h>
#include <qdir.h>
#include "info.h"
#include "helperfunctions.h"

UDG::UDG(QString s){
	bfn = s;
	dr = "";
	setType(TYPE_UDG);
	plist = new QList<QRegExp>;
}

UDG::~UDG(){
	delete plist;
}

ABProcess * UDG::unInstall(){
	ABProcess * r = new ABProcess("uninstall UDG");
	*r << "rm";
	*r << udgDir() + baseFileName() + ".config";
	*r << udgDir() + baseFileName() + ".files";
	return r;
}

void UDG::save(){
	saveConfig();
	saveFiles();
}

void UDG::saveConfig(){
	KSimpleConfig config(udgDir() + baseFileName() + ".config");
	QStrList l = patternListToStrList();
	config.writeEntry("Description",description());
	config.writeEntry("Dir",dir());
	config.writeEntry("Icon",icon());
	config.writeEntry("File Pattern",l);
	config.writeEntry("Name",name());
	config.writeEntry("Safety Level",safetyLevel());
	config.writeEntry("Max Archives",maxArchives());
	config.writeEntry("Command",command());
	config.writeEntry("Permanent", *permanent);
	
	config.setGroup("Schedule");
	config.writeEntry("Enable",scheduleEnabled());
	l = intListToStrList(schedule() -> dayList());
	config.writeEntry("Action", (unsigned int)getAction());
	config.writeEntry("Day List", l);
	l = intListToStrList(schedule() -> hourList());
	config.writeEntry("Hour List", l);
	l = intListToStrList(schedule() -> minuteList());
	config.writeEntry("Minute List", l);
	config.writeEntry("Day Cycle", schedule() -> dayCycle());
	config.writeEntry("Hour Cycle", schedule() -> hourCycle());
	config.writeEntry("Minute Cycle", schedule() -> minuteCycle());
	config.writeEntry("Last Event", lastEvent());
}

void UDG::saveFiles(){
	QFile f(udgDir() + baseFileName() + ".files");
	if (f.open(IO_WriteOnly)){
		QTextStream t(&f);
		for (uint i = 0; i < numFiles(); i++)
			t << file(i) << "\n";
		f.close();
	}	
}

void UDG::load(){
	loadConfig();
	loadFiles();
	sync();
}

void UDG::loadConfig(){
	KSimpleConfig config(udgDir() + baseFileName() + ".config");
	setDescription(config.readEntry("Description"));
	setDir(config.readEntry("Dir"));
	setIcon(config.readEntry("Icon"));
	setName(config.readEntry("Name"));
	QStrList l;
	config.readListEntry("File Pattern",l);
	strListToPatternList(l);
	setSafetyLevel(config.readNumEntry("Safety Level"));
	setMaxArchives(config.readNumEntry("Max Archives"));
	setCommand(config.readEntry("Command"));
	l.clear();
	config.readListEntry("Permanent",l);
	for (unsigned int i = 0; i < l.count(); i++)
		permanent -> append(l.at(i));
	
	config.setGroup("Schedule");
	setScheduleEnabled(config.readNumEntry("Enable"));
	setAction((action)config.readNumEntry("Action"));
	l.clear();
	config.readListEntry("Day List",l);
	schedule() -> setDayList(strListToIntList(l));
	l.clear();
	config.readListEntry("Hour List",l);
	schedule() -> setHourList(strListToIntList(l));
	l.clear();
	config.readListEntry("Minute List",l);
	schedule() -> setMinuteList(strListToIntList(l));
	schedule() -> setDayCycle(config.readNumEntry("Day Cycle"));
	schedule() -> setHourCycle(config.readNumEntry("Hour Cycle"));
	schedule() -> setMinuteCycle(config.readNumEntry("Minute Cycle"));
	setLastEvent(config.readNumEntry("Last Event"));
}

void UDG::loadFiles(){
	unloadFiles();
	QFile f(udgDir() + baseFileName() + ".files");
	if (f.open(IO_ReadOnly)){
		QTextStream t(&f);
		while (!t.eof())
			addFileFast (t.readLine());
		f.close();
	}
}

void UDG::strListToPatternList(QStrList l){
	plist -> clear();
	for (uint i = 0; i < l.count(); i++)
		addPattern(l.at(i));
}

QStrList UDG::patternListToStrList(){
	QStrList l;
	for (uint i = 0; i < plist -> count(); i++)
		l.append(plist -> at(i) -> pattern());
	return l;
}

bool UDG::tryFile(QString s){
	QFileInfo f(s);
	bool b = false;
	for (unsigned int i = 0; i < plist -> count(); i++)
	  if (plist -> at(i) -> match(f.fileName())==0)
			b = true;
	if (!dir().isEmpty() ){
		QString s_1(f.dirPath());
		s_1 = "/" + s_1 + "/";
		QString s_2(dir());
		s_2 = "/" + s_2 + "/";
			if (s_1.find(s_2) == -1)
				b = false;
	}
	if (b)
		if (numFiles() < maxFiles)
			addFileFast(f.absFilePath());
	return b;	
}

QString UDG::archiveRoot(){
	QDir d(dir());
	d.cdUp();
	if (dir().left(1) != QString("/"))
		d = QDir("/");
	return d.absPath();
}

void UDG::setDir(QString s){
	int l;
	while (s.right(1) == "/"){// remove /'s from the end
		l = s.length();
		s.remove(l-1,1);
	}
	expandTilde(s);
	dr = s;
}

/*
QString UDG::info(infotag i){
	QString b;
	switch (i){
		case INFO_NAME :
			b = name();
			break;
		case INFO_DESCRIPTION :
			b = description();
			break;
	}
	return b;
}
*/

