/***************************************************************************
                          batch.h  -  description
                             -------------------
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BATCH_H
#define BATCH_H

#include "abprocess.h"
#include "filegroupbase.h"

/**
  *@author Arjan Buursink
  */

class Batch : public QObject {
	Q_OBJECT
public: 
	Batch();
	~Batch();
	void start(bool b = false, bool c = false);
	void append(ABProcess *);
	QList<ABProcess> * procList;
	/**
	* Returns true if an error has occured.
	*/
	bool error();
	unsigned int count() { return procList -> count(); };
	ABProcess * process(int i) { return procList -> at(i); };
	void clear();
	void cancelBatch() { emit cancel(); }
private:
	unsigned int cntr;
	/**
	* This variable is set in the constructor. False means that during batch process the parent process is
	* blocked until the batch has ended
	*/
	bool cont, block;
private slots:
	void slotCont();
signals:
	void cancel();
	void exit();	
	void processExited();
};

#endif
