/***************************************************************************
                          grouptree.h  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GROUPTREE_H
#define GROUPTREE_H

#include <qobject.h>
#include <qstring.h>
#include <qlistview.h>
#include <qpopupmenu.h>	

#include "cleanupwizard.h"
#include "filegroupbase.h"
#include "buttonlabelwidget2.h"

/**
  *@author Arjan Buursink
  */
class GroupViewWidget;

class GroupTree : public QObject {
	Q_OBJECT
public:
	GroupTree(GroupViewWidget *);
	~GroupTree();
	void deleteTree();
	void deleteItem(QString);
	QListViewItem * topItem() { return _topItem;};
	QListViewItem * topItem(QListViewItem *);
	QListViewItem * item(QListViewItem *, QString);
	QString name(QListViewItem *);
	grouptype type() { return _type; };
	void setType(grouptype t) { _type = t; };
	GroupViewWidget * groupViewWidget() { return _groupViewWidget; };
	
	// Group actions
	void addGroup(FileGroupBase * g);
	void removeGroup(QString n);
	void removeGroup(FileGroupBase * g);
	FileGroupBase * group(unsigned int i) {return _groupList -> at(i);};
	FileGroupBase * group(QString);
	unsigned int groupCount(){return _groupList -> count();};
	unsigned int numMarked();
	
protected:
	QListView * listView() { return _listView; };
	void 	setupItem(FileGroupBase *, QListViewItem *);
	virtual void groupToItem(FileGroupBase *, QListViewItem *) {};
	QPopupMenu * popup;
	QListViewItem * selectedItem(){	return listView() -> currentItem();};
	bool hasAncestor(QListViewItem *, QListViewItem *);
	QListViewItem * itemHasChild(QListViewItem *, QString);
	grouptype _type;
	CleanupWizard * cleanupWizard;
	GroupViewWidget * _groupViewWidget;
	void setupReady();
	ABProcess * updateProcess;
//	ButtonLabelWidget2 * updateProgress;
private:
	QListViewItem * _topItem;
	QListView * _listView;
	QList<FileGroupBase> * _groupList;
	virtual void itemClicked(QListViewItem *, const QPoint &, int) {};
	virtual void updateReady(){};
	virtual void setup(){};
private slots:
	void slotUpdateReady();
	void slotCleanupEnded();
	void slotCleanupCancelled();
	void slotItemClicked(QListViewItem *, const QPoint &, int);
	void slotCleanup(FileGroupExt*);
	virtual void slotPopup(QListViewItem *, const QPoint &, int){};
signals:
	void setupFileList(FileGroupBase*);
	void setProperties(FileGroupBase*);
	
};

#endif
