/***************************************************************************
                          insitem.cpp  -  description
                             -------------------
    begin                : Sat Dec 16 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include <qdir.h>
#include <kiconloader.h>
#include <kleandisk.h>
#include "info.h"
#include "abprocess.h"
#include "instree.h"
#include "groupviewwidget.h"

INSTree::INSTree(GroupViewWidget * gv) : GroupTree(gv){
	setType(TYPE_INS);
	KIconLoader l;
	topItem() -> setText(0,"Installed Files");
	topItem() -> setPixmap(0,l.loadIcon("mime_empty", KIcon::Small));	
}

INSTree::~INSTree(){
}

void INSTree::setup(){
	bool b = false;
	QDir d(insDir());
	QStringList * l = new QStringList(d.entryList());
	for (unsigned int j = 0; j < l -> count(); j++){
		QFileInfo f(insDir() + QString(*l -> at(j)));
		QString s(f.fileName());
		if (s.right(6) == ".files"){
			b = true;
			INS * in = new INS(f.baseName());
			in -> loadFiles();
			if (in -> numFiles() == 0){
				ABProcess * p = new ABProcess();	
				*p << "rm" << "-vf";
				*p << insDir() + in -> baseFileName() + ".files";
				*p << insDir() + in -> baseFileName() + ".config";
				p -> exec();
				delete in;
			}
			else
				addGroup(in);
		}
	}
	delete l;
}

void INSTree::itemClicked(QListViewItem * i, const QPoint &p, int c){
	if (!topItem() -> childCount()){
		setup();
	}
	if (i == topItem())
	  i -> setOpen(!i -> isOpen());
	if (c == 0 && i != topItem()){
		emit setupFileList(group(name(i)));
		emit setProperties(group(name(i)));
	}
	if ( c == 1){
		INS * ins = (INS*) group(name(i));
		ins -> setMarked(!ins -> isMarked());
		if (ins -> isMarked()){
			KIconLoader icnl;
			i -> setPixmap(1,QPixmap(icnl.loadIcon("flag",KIcon::Small)));
		}
		else
			i -> setPixmap(1,QPixmap());
		setupItem(ins,i);
	}
	setupReady();
}

void INSTree::slotCleanupEnded(){
	INS * i;
	i = (INS*) group(name(selectedItem()));
	i -> empty();
	i -> loadFiles();
	setupItem(i,selectedItem());
	groupViewWidget() -> FileListView1 -> setFileGroup(i);
}

void INSTree::groupToItem(FileGroupBase * ins, QListViewItem * i){
	KIconLoader l;
	i -> setPixmap(0,l.loadIcon(ins -> icon(), KIcon::Small));
}
