/***************************************************************************
                          kdlgopenmanager.cpp  -  description
                             -------------------
    begin                : Fri Sep 29 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.5 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qtooltip.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include "kdlgopenmanager.h"

KDlgOpenManager::KDlgOpenManager(QWidget *parent, const char *name) 
  : QDialog(parent,name,true){
  _title = QString::null;
  initDialog();
  setCaption(i18n("New Manager"));
}

KDlgOpenManager::~KDlgOpenManager(){
}

void  KDlgOpenManager::initDialog(){

  QBoxLayout *l = new QVBoxLayout(this, 8);

  QGroupBox *gbox = new QGroupBox(1, Horizontal, this);
  l->addWidget(gbox);

  new QLabel(i18n("Manager Title"), gbox, "LblTitle");
  lneTitle = new QLineEdit(gbox, "LneTitle");

  QHBoxLayout *btnBox = new QHBoxLayout(l);
  btnBox->addStretch(1);

  QPushButton *btn = new QPushButton(i18n("OK"), this, "BtnOK");
  btn->setDefault(true);
  btnBox->addWidget(btn);
  connect(btn, SIGNAL(clicked()), this, SLOT(accept()));

  btn = new QPushButton(i18n("Cancel"), this, "BtnCancel");
  btnBox->addWidget(btn);
  connect(btn, SIGNAL(clicked()), this, SLOT(reject()));
}

QString KDlgOpenManager::exec() {
  if (QDialog::exec() == Accepted) 
    return _title; 
  else 
    return QString::null;
}

void KDlgOpenManager::accept() {
  _title = lneTitle->text();
  QDialog::accept();
}

#include "kdlgopenmanager.moc"
