/***************************************************************************
                          kmmanager.h  -  description
                             -------------------
    begin                : Wed Oct 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.3 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMMANAGER_H
#define KMMANAGER_H

#include "kcontainer.h"
#include "knotifychange.h"

class KMManagerImpl;
class KTManager;

/**container of KTManagerImpl objects
  *@author Sergio Moretti
  */

class KMManager : public KContainer {
  friend class KObject;

public: 
  KMManager() {}

  /** document name */
  static QString docId();
  /** dom document type */
  static QString docType();
  /** mime type */
  static QString mimeType(int i);

  /** static function to create a manager */
  static KMManager managerLoad(const QString &fileName, bool createMode,
			       KNotifyChange *cb);
  bool save(const QString &filename = QString::null);
  /** new item */
  KTManager itemNew(const QString &title);
  /** bandwidth */
  int bandwidth() const;
  /** medium bandwidth */
  int mediumBandwidth() const;
  QString fileName() const;
  bool needSaving() const;

protected:
  KMManager(KMManagerImpl *impl);
  KMManagerImpl * impl() const;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
