/***************************************************************************
                          kobject.cpp  -  description
                             -------------------
    begin                : Fri Oct 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.4 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include "kfactoryimpl.h"
#include "kobjectimpl.h"
#include "kcontainerimpl.h"
#include "ktransferimpl.h"
#include "ktmanagerimpl.h"
#include "kmmanagerimpl.h"
#include "ktransferwgetimpl.h"
#include "ktransferkioimpl.h"

#include "kcontainer.h"
#include "ktransfer.h"
#include "ktmanager.h"
#include "kmmanager.h"
#include "ktransferwget.h"
#include "ktransferkio.h"
#include "kobject.h"


int KObject::id() const { 
  return impl()->id(); 
}

QString KObject::name() const { 
  return impl()->name(); 
}

int KObject::type() const { 
  return impl()->type(); 
}

QDomElement KObject::dom() const {
  return impl()->dom();
}

bool KObject::isModified(ModType type) const {
  return impl()->isModified(type);
}

void KObject::setModified(ModType type, PropMode prop, bool mod) {
  impl()->setModified(type, prop, mod);
}

bool KObject::isGlobal() const {
  return impl()->isGlobal();
}

void KObject::setGlobal(bool g) {
  impl()->setGlobal(g);
}

void KObject::update() {
  impl()->update();
}

void KObject::deleteInstance() {
  delete impl();
  _impl = 0;
}

void KObject::runPeriodically() { 
  impl()->runPeriodically(); 
}

bool KObject::connect(const char *signal, const QObject *receiver, 
			     const char *member) const {
  return impl()->connect(impl(), signal, receiver, member);
}

KContainer KObject::container() const { 
  return KContainer(impl()->container()); 
}

QObject * KObject::toQObject() const {
  return static_cast<QObject*>(impl());
}

KContainer KObject::toContainer() const {
  return KContainer(dynamic_cast<KContainerImpl*>(impl())); 
}

KTransfer KObject::toTransfer() const {
  return KTransfer(dynamic_cast<KTransferImpl*>(impl())); 
}

KTManager KObject::toTManager() const {
  kdFatal(dynamic_cast<KTManagerImpl*>(impl()) != impl()) << "toTManager null" << endl;
  return KTManager(dynamic_cast<KTManagerImpl*>(impl())); 
}

KMManager KObject::toMManager() const {
  return KMManager(dynamic_cast<KMManagerImpl*>(impl())); 
}

KTransferWget KObject::toTransferWget() const {
  return KTransferWget(dynamic_cast<KTransferWgetImpl*>(impl())); 
}

#ifdef ENABLE_KIO
KTransferKio KObject::toTransferKio() const {
  return KTransferKio(dynamic_cast<KTransferKioImpl*>(impl())); 
}
#endif

QString KObject::typeStr(int type) {
  return KFactoryImpl::factory()->typeStr(type);
}

void KObject::initFactory() {
  // init once
  if (KFactoryImpl::factory()->prototype(TYP_MMANAGER) != 0)
    return;
  KFactoryImpl::factory()->addPrototype(TYP_MMANAGER,
					new KMManagerImpl(TYP_MMANAGER), 
					"MManager");
  KFactoryImpl::factory()->addPrototype(TYP_TMANAGER,
					new KTManagerImpl(TYP_TMANAGER), 
					"TManager");
  KFactoryImpl::factory()->addPrototype(TYP_TWGET,
					new KTransferWgetImpl(TYP_TWGET), 
					"Wget");
#ifdef ENABLE_KIO
  KFactoryImpl::factory()->addPrototype(TYP_TKIO,
					new KTransferKioImpl(TYP_TKIO), 
					"Kio");
#endif
}
