/*
    KMLOCfg
    
    A utility to configure the ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef CONFIGURE_H
#define CONFIGURE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qtabdialog.h>
#include <qwidget.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcombobox.h>

#include <kconfig.h>
#include <kdialogbase.h>


class Configure : public KDialogBase
{
	Q_OBJECT
public:
	Configure(QWidget *parent = 0, const char *name = 0, bool modal = false);
	~Configure();

	void addToolTips(bool on);

protected:
	void reset();

protected slots:
	virtual void slotDefault();
	virtual void slotOk();
	virtual void slotApply();
	virtual void slotCancel();

signals:
	void newConfig();

private:
	KConfig *config;

	bool gotToolTips;

	QCheckBox *gen_tooltips;

	QLineEdit *mod_device;
	QComboBox *mod_speed;
};


extern Configure *configure;

#endif // CONFIGURE_H
