/*
    KMLOVoice

    A utility to process voice messages received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef VOICEVIEW_H
#define VOICEVIEW_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qlistview.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qpopupmenu.h>
#include <qstring.h>

#include <klistview.h>

#include <kconfig.h>

#include "senderaliases.h"




class VoiceViewItem : public QListViewItem
{
public:
	VoiceViewItem(QListView *parent = 0, const char *name = 0);
	virtual ~VoiceViewItem();

	void setName(const QString& name);
	QString name();
	void setNew(bool isnew);
	bool isNew();
	void setCaller(const QString& caller_);
	QString caller();
	void setType(uchar type_);
	uchar type();
	void setSize(uint size_);
	uint size();
	void setFile(bool hasfile);
	bool hasFile();
	void setDuration();
	void setAlias();
	QString alias();
	
	void setParams(const QString& name_, bool isnew_, const QString& caller_, uchar type_, uint size_);

private:
	bool m_new;
	QString m_caller;
	uchar m_type;
	uint m_size;
	bool m_file;
};


inline QString VoiceViewItem::name()
{ return text(0); }

inline bool VoiceViewItem::isNew()
{ return m_new; }

inline QString VoiceViewItem::caller()
{ return m_caller; }

inline uchar VoiceViewItem::type()
{ return m_type; }

inline uint VoiceViewItem::size()
{ return m_size; }

inline bool VoiceViewItem::hasFile()
{ return m_file; }

inline QString VoiceViewItem::alias()
{ return text(3); }



class VoiceView : public KListView
{
	Q_OBJECT
public:
	VoiceView(QWidget *parent = 0, const char *name = 0);
	virtual ~VoiceView();

	void readOptions();
	void saveOptions();

	int loadDir();
	void saveDir();
	void purgeDir();

	void addVoiceItem(const QString& name, uchar type, const QString& caller);

	bool selectedMsgNew();
	void setSelectedMsgNew(bool isnew);
	QString selectedMsgName();
	uchar selectedMsgType();
	QString selectedMsgCaller();
	QString selectedMsgAlias();
	bool selectedMsgFile();
	void setSelectedMsgFile(bool fexists);

	void gotSelection(bool on);

private slots:
	void enableCommand(int id_, bool enable);
	
	void selectionChangedSlot(QListViewItem *item);
	void doubleClickedSlot(QListViewItem *item);
	void returnPressedSlot(QListViewItem *item);
	void rightButtonClickedSlot(QListViewItem *item, const QPoint& point, int);
	void refreshAliases();
	void contextMenuSlot(int id_);

signals:
	void hasSelection(bool);
	void playBackRequested(VoiceViewItem *);

	void command(int);
	
private:
	KConfig *config;

	bool got_tooltips;

	VoiceViewItem *selectedItem;

	QPopupMenu *contextMenu;
};


#endif // VOICEVIEW_H
