/**
 * undomanager.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_UNDOMANAGER_H
#define KONFIG_UNDOMANAGER_H

#include <qobject.h>
#include <qptrlist.h>

namespace KCfgCreator
{
    class Token;
    class Memento;
    class UndoManager : public QObject
    {
        Q_OBJECT
    public:
        typedef QPtrList<Memento> UndoList;
        static UndoManager* Instance();

        bool canUndo() const;

        bool undo( Memento* memento=0 );

        void addMemento( Memento* );

        UndoList undoList() const;
    signals:
        void canUndo( bool );
        void tokenRestored( Token* );

    private:
        UndoManager();
        UndoList m_mementoList;
        static UndoManager *s_self;
    };
}

#endif
