/**
 * confwindow.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#ifndef KCONF_WINDOW_H
#define KCONF_WINDOW_H

#include <kmainwindow.h>

class KConfMainWidget;

namespace PropertyLib {
    class PropertyEditor;
}

namespace KConfigEditor {

    class ConfigurationView;
    class ViewManager;
    class DescriptionWidget;
    class StatusbarProgressWidget;
    class ProgressDialog;

    class ConfWindow : public KMainWindow
    {
        Q_OBJECT
    public:
        ConfWindow( const char *title );

    protected slots:
        void slotStatusMsg( const QString &str );
        void slotUndo();
        void slotAddEntry();
        void slotRemoveEntry();
        void slotUpdateActions( bool );
        void delayedInit();
        void slotSave();
        void slotShowChanges();
        void slotDoneParsing();

    private:
        void initActions();
        void initStatusbar();
        void initGUI();
        void initConnections();

    private:
        QWidget *m_mainWidget;
        DescriptionWidget *m_descrWidget;
        ConfigurationView *m_view;
        PropertyLib::PropertyEditor *m_editor;
        ViewManager* m_manager;
        StatusbarProgressWidget *m_littleProgress;
        ProgressDialog *m_progressDialog;
    };

}

#endif
