#include <qsqlresult.h> 
#include <qsqldriver.h> 
#include <qsqldriverplugin.h>

#include <sqlite.h>


class SqliteDriver: public QSqlDriver
{
public:
	SqliteDriver (QObject * parent = 0, const char *name = 0);
	bool open ( const QString & db, const QString & user = QString::null,
			const QString & password = QString::null, const QString
			& host = QString::null, int port = -1 );
	void close ();
	bool hasFeature ( QSqlDriver::DriverFeature f ) const;
	QSqlQuery createQuery () const;
	virtual QStringList tables( const QString& user ) const;
	QSqlRecord record ( const QString & tableName ) const;
	QSqlRecordInfo recordInfo ( const QString & tablename ) const;
	QSqlIndex primaryIndex ( const QString & tableName ) const
	{
		qDebug ("STUB primaryIndex");
		return QSqlDriver::primaryIndex(tableName);
	};
	bool beginTransaction ();
	bool commitTransaction ();
	bool rollbackTransaction ();
	sqlite * _db;
};
class SqliteResult: public QSqlResult
{
public:
	SqliteResult (const QSqlDriver *db);
	bool reset (const  QString & query );
	bool fetch (int i);
	QVariant data(int i);
	bool isNull(int i);
	void setQuery (const QString & query );
	bool fetchFirst() 
	{
		if (nrows>0)
		{
			setAt(0);
			return true;
		}
		else
			return false;
	};

	bool fetchLast() 
	{
		if (nrows>0)
		{
			setAt(nrows);
			return true;
		}
		else
			return false;
	};
	
	int size() 
	{
		qDebug ("sqliteresult::size %d",nrows);
		return nrows;
	};

	//It seems sqlite doesn'gt report this :-P
	int numRowsAffected();
	
	int nrows,ncols;	
	char **results;
	SqliteDriver *_db;
	QString q;
	int affected;
};


class SqlitePlugin: public QSqlDriverPlugin
{
public:
	SqlitePlugin(){}
	~SqlitePlugin() {}
	QStringList keys() const 
	{
		return QStringList() << "sqlite";
	}
	QSqlDriver *create (const QString &)
	{
		return new SqliteDriver();
	}
};


Q_EXPORT_PLUGIN( SqlitePlugin )
