/***************************************************************************
                          processfiledlg.cpp  -  description
                             -------------------
    begin                : Fri Oct 5 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "processfiledlg.h"
#include <qpopupmenu.h>
#include "bibtexfactory.h"
#include <kscan.h>
#include <qstring.h>
#include <kmdcodec.h>
#include <kio/netaccess.h>
#include "convert2text.h"
#include <klocale.h>
#include <kmimemagic.h>
#include <kaspasql.h>
#include <qstrlist.h>
#include <qprogressbar.h>
#include <qtextview.h>
#include <qlabel.h>
#include <kapp.h>
#include <kmessagebox.h>
#include "partdatabase.h"
#include "kaspabase.h"
#include <qpushbutton.h>

ProcessFileDlg::ProcessFileDlg(Sql *conn, QWidget *parent, const char *name ) :
  ProcessFile(parent,name), canceled(false), sql(conn) {
  connect(cancel, SIGNAL(clicked()), this, SLOT(slotCanceled()));
}
ProcessFileDlg::~ProcessFileDlg(){
}

void ProcessFileDlg::slotCanceled() {
  canceled=true;
}

void ProcessFileDlg::slotImportFiles(QStrList l,  Oid partid) {
  progress->setTotalSteps(l.count());
  int i=0;
  char *s=l.first();
  do {
    file->setText(s);
    i++;
    progress->setProgress(i);
    out+="\n"+QString(s)+"\n";
    slotImportFile(s, partid);
  } while(!canceled && (s=l.next()));
}


void ProcessFileDlg::slotCreateReferences(QStrList l, Oid partid) {
  progress->setTotalSteps(l.count());
  int i=0;
  char *s=l.first();
  action->setText(i18n("Creating references..."));
  do {
    file->setText(s);
    out+="\n"+QString(s)+"\n";
    i++;
    progress->setProgress(i);
    kapp->processEvents();
    slotCreateReference(s, partid);
  }  while(!canceled && (s=l.next()));
}


void ProcessFileDlg::slotOutput(QString s) {
  out+=s;
  output->setText(out);
}

void ProcessFileDlg::slotRebuildText(bool all) {
  PartDataName *n=0L;
  try {
    KaspaBase k(sql);
    QString where;
    if(!all)
      n=k.getPartDataNames("where astext='' or astext is null");
    else
      n=k.getPartDataNames("");
    int c=0;
    for(PartDataName *p=n; p; p=p->getNext())
      c++;
    progress->setTotalSteps(c);

    int i=0;
    for(PartDataName *p=n; p; p=p->getNext()) {
    try {
      i++;
      progress->setProgress(i);
      out+="\n";

      kapp->processEvents();
      QString where("where partdata.no=");
      where+=QString().setNum(p->getOid());
      PartDataBase d(where, sql);
      const char* f=d.getFilename();
      file->setText(f);
      out+=f; out+="\n";
      const char* buf=d.getData();

      QByteArray in=QByteArray().duplicate(buf, strlen(buf));
      QByteArray out;
      KCodecs::base64Decode(in, out);

      KMimeMagicResult *res=KMimeMagic::self()->findBufferFileType(out, f);
      QString txtbuf=slotConv2Text(out, res);
      d.setText(txtbuf.simplifyWhiteSpace());
      d.setType(res->mimeType());
      d.flush();
      if(canceled) break;
    } catch(KaspaErr err) {
			KMessageBox::error(this, err.error());
    }
  }
  } catch (...) {
    delete n;
    throw;
  }
}

QString ProcessFileDlg::slotConv2Text(QByteArray buffer, KMimeMagicResult *res) {
  action->setText(i18n("Convert to text..."));
  // Mimetype
  QString txtbuf;
  Convert2Text conv;
  connect(&conv, SIGNAL(output(QString)), this, SLOT(slotOutput(QString)));
/*
	if(res->mimeType()=="text/html") txtbuf=conv.html2text(buffer);
  else if(res->mimeType()=="text/plain") txtbuf=QString(buffer);
  else if(res->mimeType().left(4)=="text") txtbuf=QString(buffer);
  else if(res->mimeType()=="application/pdf") txtbuf=conv.pdf2text(buffer);
//  else if(res->mimeType()=="application/postscript") txtbuf=conv.ps2text(buffer);
*/
  conv.mime2text(res->mimeType(), buffer, txtbuf);
  return txtbuf;
}


void ProcessFileDlg::slotCreateReference(QString s, Oid partid) {
  // New PartData-record...
  PartDataBase file(partid, sql);
  file.setFilename(s);
  file.flush();
}


void ProcessFileDlg::slotImportFile(QString s, Oid partid) {
  char *buf=0L;
  QString target;

  try {
  action->setText(i18n("Open file..."));
	// Build path+filename and setup progressbar...
  debug("Part::importItem() - file: %s", (const char *) s);

  if (KIO::NetAccess::download(s, target) == false)
    throw KaspaErr(i18n("Cannot download file!"));

  // Read file...
  QFile f(target);
  if(!f.open(IO_ReadOnly))
    throw KaspaErr(i18n("Unable to open file for reading!"));
  buf=new char[f.size()];
  if(f.readBlock(buf, f.size())!=int(f.size()))
    throw KaspaErr("Unable to read from file!");

  // Mimetype
  QByteArray buffer;
  buffer.duplicate(buf, f.size());
  KMimeMagicResult *res=KMimeMagic::self()->findBufferFileType(buffer, target);
  QString txtbuf=slotConv2Text(buffer, res);

  action->setText(i18n("Writing file into database..."));
  // New PartData-record...
  PartDataBase file(partid, sql);
  file.setFilename(QString("kaspa:/")+s.right(s.length()-s.findRev("/")));
  file.setData(KCodecs::base64Encode(buffer, false));
  file.setText(txtbuf.simplifyWhiteSpace());
  file.setType(res->mimeType());
  file.flush();

  // cleanup...
  delete buf; buf=0L;
  KIO::NetAccess::removeTempFile(target);
  } catch(...) {
      delete buf;
      KIO::NetAccess::removeTempFile(target);
      throw;
  }
}