/***************************************************************************
                          state.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kmessagebox.h>
#include "state.h"
#include "kaspasql.h"
#include "qstring.h"
#include <klocale.h>
#include <qpixmap.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <qsizepolicy.h>

#define Inherited StateData

State::State(KaspaURL url, Sql *conn, QWidget* parent, const char* name):	
		Inherited( parent, name ) {
	try {
    QString pic=KGlobal::dirs()->findResource("data", "kaspaliste/pics/books.jpg");
    QPixmap p;
    p.load(pic);
    image->setScaledContents(true);
    image->setPixmap(p);
    author->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Preferred));
    file->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Preferred));
    this->setBackgroundMode( QWidget::PaletteBase );


		_url=url;
		sql=conn;
    if(!sql) throw KaspaErr(i18n("Invalid database connection!"));
    sql->exec("select count(*) from author");
    if(sql->tuples())
			author->setText(QString(sql->getValue(0, "count"))+" authors");

    sql->exec("select count(*) from publication");
    if(sql->tuples())
			publication->setText(QString(sql->getValue(0, "count"))+" publications");

    sql->exec("select count(*) from part");
    if(sql->tuples())
			part->setText(QString(sql->getValue(0, "count"))+" parts");

    sql->exec("select count(*) from partdata");
    if(sql->tuples())
			file->setText(QString(sql->getValue(0, "count"))+" files");

    sql->exec("select count(*) from publisher");
    if(sql->tuples())
			publisher->setText(QString(sql->getValue(0, "count"))+" publishers");

	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


State::~State() {
}
