/***************************************************************************
                          state.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef State_included
#define State_included

#include "statedata.h"
#include "kaspaurl.h"
#include "partbase.h"
#include <qlayout.h>
#include <qdir.h>

class State : public StateData
{
    Q_OBJECT

private:
		State(const State&);
		State& operator=(const State&);

		KaspaURL _url;
		Sql	*sql;

public:

    State(KaspaURL url, Sql *conn, QWidget* parent = 0L, const char* name = 0L);
    virtual ~State();
		bool closeRequest() { return true; }
		const char *url() { return _url; }
		virtual bool isValid() { return true; }
		virtual bool isWorking() { return false; }
		virtual bool isReadOnly() { return false; }
		void setInvalidGUI() { StateData::setInvalidGUI(); lockGUI(); }
		void setWorkingGUI() { StateData::setWorkingGUI(); lockGUI(); }
		void setReadWriteGUI() { StateData::setReadWriteGUI(); unlockGUI(); }
public slots:
};
#endif
