/***************************************************************************
                          htmldata.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: htmldata.cpp
	Last generated: Sun Sep 26 14:18:38 1999

 *********************************************************************/



#include "htmldata.h"

#define Inherited HTMLDataData

#include "resource.h"

#include <kapp.h>
#include <qaccel.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <kiconloader.h>
#include <qclipboard.h>
#include "selectiondlg.h"
#include "notetreedlg.h"
#include "kaspawidget.h"
#include <klocale.h>


#define Inherited HTMLDataData

CommandSetup htmldatacs[] = {	{ID_HTML_SHOWPART,  RW+RO},
															{ID_HTML_NEWLINK, 	RW+RO},
															{ID_HTML_INSLINK, 	RW+RO},
															{ID_HTML_REMLINK,		RW+RO},
															{ID_HTML_RESET,			RW+RO+INV} };

// HTMLDataBase-Constructor reads row matching WHERE-Clause.
HTMLData::HTMLData(KaspaURL url, Sql *conn, QWidget* parent,	const char* name):
	Inherited( parent, name), handling_request(false)
{
	tmpfiles.setAutoDelete(true);
//	debug("HTMLData::HTMLData(QString, QWidget, char*)");
  htmldata = new PartDataBase(url.where(), conn);
  ASSERT(htmldata);
	QString s("kaspa://partdata#where partdata.no="); s+=QString().setNum(htmldata->id());
	_url=s;
  connect(notes, SIGNAL(open(Oid, bool)), this, SLOT(requestNote(Oid, bool)));
  connect(html, SIGNAL(urlClick(QString)),
					this, SLOT(handleURLRequest(QString)));


  QAccel* htmlkeys = new QAccel(this);
	htmlkeys->connectItem( htmlkeys->insertItem( Key_PageDown ), html, SLOT(slotVertAddPage()) );
	htmlkeys->connectItem( htmlkeys->insertItem( Key_PageUp ), 	 html, SLOT(slotVertSubtractPage()) );
	htmlkeys->connectItem( htmlkeys->insertItem( Key_Down ), 		 html, SLOT(slotVertAddLine()) );
	htmlkeys->connectItem( htmlkeys->insertItem( Key_Up ), 		 	 html, SLOT(slotVertSubtractLine()) );

	notes->setTitle("Links");
}

HTMLData::~HTMLData()
{
//	debug("HTMLData::~HTMLData()");
	delete htmldata;
	for(unsigned int i=0; i<tmpfiles.count(); i++) {
//		debug("HTMLData::~HTMLData() - deleteing file %s", tmpfiles.at(i)->name());
		tmpfiles.at(i)->remove();
	}
}

bool HTMLData::isValid() {
	try {
	  return htmldata->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}


void HTMLData::reread() {
	try {
		setWorkingGUI();
  	htmldata->reset();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
	  setFields();
}

void HTMLData::setFields() {
  if(isValid()) {
		setWorkingGUI();

		try {
			Title *p;
			if((p=htmldata->getPublTitle())) publtitle->setText(p->getTitle());
			else throw KaspaErr("File has no Publication!");

			if((p=htmldata->getPartTitle())) parttitle->setText(p->getTitle());
			else throw KaspaErr("File has no Part!");

		  filename->setText(htmldata->getFilename());
			long l;
			char *buf=(char *)htmldata->getData();
			if(buf) {
					if(buf[l]!=0) {
//						debug("buf[l]!=0");
					buf[l]=0;
				}
				QString s("kaspa:/");
				s+=htmldata->getFilename();
				html->setText(buf);
				
			}
		  notes->set(htmldata->getLinks());
		} catch(KaspaErr& err) {
			handleWarning(err);
		}
	}
	setupGUI();
}


void HTMLData::setInvalidGUI() {
	Inherited::setInvalidGUI();
	lockGUI();
	for(unsigned int i=0; i<sizeof(htmldatacs)/sizeof(CommandSetup); i++)
		emit enableCommand(htmldatacs[i].command, ((htmldatacs[i].setup&INV)==INV));
}	

void HTMLData::setReadWriteGUI() {
 	Inherited::setReadWriteGUI();
 	unlockGUI();
	for(unsigned int i=0; i<sizeof(htmldatacs)/sizeof(CommandSetup); i++)
		emit enableCommand(htmldatacs[i].command, ((htmldatacs[i].setup&RW)==RW));
}

void HTMLData::setWorkingGUI() {
	Inherited::setWorkingGUI();
  notes->setEnabled(false);
	for(unsigned int i=0; i<sizeof(htmldatacs)/sizeof(CommandSetup); i++)
		emit enableCommand(htmldatacs[i].command, ((htmldatacs[i].setup&WORK)==WORK));
}

void HTMLData::setReadOnlyGUI() {
	Inherited::setReadOnlyGUI();
	lockGUI();
	notes->setEnabled(TRUE);
	for(unsigned int i=0; i<sizeof(htmldatacs)/sizeof(CommandSetup); i++)
		emit enableCommand(htmldatacs[i].command, ((htmldatacs[i].setup&RO)==RO));
}



bool HTMLData::closeRequest() {
  return true;
}
	
void HTMLData::newLink() {
	try {
		setWorkingGUI();
		Oid o=htmldata->createNote();
		requestNote(o);
		setupGUI();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
	
void HTMLData::insLink() {
	try {
		SelectionDlg dlg(htmldata->getNotes(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			htmldata->insertLink(o);
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		
	
void HTMLData::remLink() {
	try {
		Oid o=notes->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		htmldata->removeLink(o);
		setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
		
void HTMLData::showPart() {
	requestPart(htmldata->getPartNo());
}


KToolBar *HTMLData::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
  toolbar->insertButton(BarIcon("newnote.png"), ID_HTML_NEWLINK, SIGNAL(clicked()),
				this, SLOT(newLink()), true, i18n("New Note") );
  toolbar->insertButton(BarIcon("insnote.png"), ID_HTML_INSLINK, SIGNAL(clicked()),
				this, SLOT(insLink()), true, i18n("Insert Note") );
  toolbar->insertButton(BarIcon("delnote.png"), ID_HTML_REMLINK, SIGNAL(clicked()),
				this, SLOT(remLink()), true, i18n("Delete Note") );

	toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("showpart.png"), ID_HTML_SHOWPART, SIGNAL(clicked()),
				this, SLOT(showPart()), true, i18n("Show Part") );

	toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("reload.png"), ID_HTML_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
  return toolbar;
}


void HTMLData::handleURLRequest(QString url) {
	if(handling_request) return;
	handling_request=true;

	QString u("kaspa://partdata#where filename='");

	/* Remove all leading ".../.../" */

	const char *dummy=esc4sql(url.right((url.findRev('/')==-1)?url.length():url.length()-url.findRev('/')-1));
	u+=dummy;
	delete dummy;
	u+="' and part_no=";
	u+=QString().setNum(htmldata->getPartNo());
  requestURL(u, false);
	handling_request=false;
}

void HTMLData::copy() {
	QString s=html->selectedText();
	if(!s.isEmpty())
		kapp->clipboard()->setText(s);
}