/***************************************************************************
                          kaspaurl.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          kaspaurl.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Mar 29 2000                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kaspaurl.h"
#include <qregexp.h>

/*
Parsing
kaspa://table[(?Command)|(.field=value)]
kaspa://table?command
kaspa://table#where
  */

KaspaURL::KaspaURL(const char *url){
	_url=url;
}

KaspaURL::~KaspaURL(){
}

const bool KaspaURL::valid() {
	if(_url.find(QRegExp("^kaspa://[a-zA-Z0-9]+[?]*[a-zA-Z0-9]*[#]*.*"))!=-1) return true;
	else return false;
}

const bool KaspaURL::hasWhere() {
	if(_url.find(QRegExp("#[a-zA-Z0-9]+"))!=-1) return true;
	else return false;
}

const bool KaspaURL::hasCommand() {
	if(_url.find(QRegExp("\\?[a-zA-Z0-9]+"))!=-1) return true;
	else return false;
}

const QString& KaspaURL::where() {
	static QString w;
	if(!hasWhere()) return (w="");
	w=_url.mid(_url.find("#")+1, _url.length());
	return w;
}

const QString& KaspaURL::table() {
	static QString s;
	if(valid()) {
		int i;
		if( ((i=_url.find("#"))==-1) && ((i=_url.find("?"))==-1) )
			i=_url.length();
//		debug("KaspaURL::table() return: %s", (const char *)_url.mid(8, i-8));
		return (s=_url.mid(8, i-8));
	}
	else
		return (s="");
}

const QString& KaspaURL::command() {
	static QString s;
	if(hasCommand()) {
		s=_url.right(_url.length()-_url.find("?")-1);
//		debug("KaspaURL::command() - len: %d ?: %d url=%s", _url.length(), _url.find("?"), (const char *)s);
		return s;
	}
	else
		return (s="");
}



