#include <qcheckbox.h>
#include <qlineedit.h>
#include <qvbox.h>

#include <klocale.h>
#include <kfile.h>
#include <kmessagebox.h>
#include <kurl.h>
#include <kurlrequester.h>

#include "global.h"
#include "connectioneditwidget.h"
#include "connectioneditdialog.h"

ConnectionEditDialog::ConnectionEditDialog( QWidget *parent, const char *name )
    : KDialogBase( Tabbed, i18n("Connection Configuration"), 
                   Ok | Apply | Cancel, Ok, parent, name, false )
{
    QVBox *page = addVBoxPage( i18n("Connection") );
    m_connectionWidget = new ConnectionEditWidget( page, "connection edit" );

    m_connectionWidget->RemoteURLLineEdit->setMode( KFile::Directory );
    m_connectionWidget->LocalURLLineEdit->setMode( KFile::Directory );
    
    setMinimumWidth( 500 );
}

ConnectionEditDialog::~ConnectionEditDialog()
{
}

void ConnectionEditDialog::setConnection( const KSynkConnection& 
                                          newConnection )
{
    m_connectionIdentifier = newConnection.getName();

    m_connection = KSynkConnection( newConnection );
    m_connectionWidget->RemoteURLLineEdit->setURL(m_connection.getRemoteURL().prettyURL());
    m_connectionWidget->LocalURLLineEdit->setURL(m_connection.getLocalURL().prettyURL());
    m_connectionWidget->ConnectionNameLineEdit->setText(m_connection.getName());
    m_connectionWidget->cbIgnoreModTime->setChecked(m_connection.ignoreModifcationTime());
}

/** Accept the changes, and call standard dialog accept() */
void ConnectionEditDialog::accept()
{
    QString name = m_connectionWidget->ConnectionNameLineEdit->text();

    if ( name.isEmpty() )
    {
        KMessageBox::error( this, i18n("You need specify a name for this connection."),
                            i18n("Missing Connection Name") );
        m_connectionWidget->ConnectionNameLineEdit->setFocus();
        return;
    }

    m_connection.setName( name );
    m_connection.setRemoteURL( m_connectionWidget->RemoteURLLineEdit->url() );
    m_connection.setLocalURL( m_connectionWidget->LocalURLLineEdit->url() );
    m_connection.setIgnoreModificationTime( m_connectionWidget->cbIgnoreModTime->isChecked() );

    KDialogBase::accept();
}

#include "connectioneditdialog.moc"
