/***************************************************************************
                          ksynkconnection.h  -
 Used to store all the information about a connection.
                             -------------------
    begin                : Sun Aug 19 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSYNKCONNECTION_H
#define KSYNKCONNECTION_H

#include <kurl.h>

class KConfig;

/**A class that represents the data associated with a single connection
 *@author Jonathon Sim
 */

class KSynkConnection
{
public:
    KSynkConnection();
    KSynkConnection( const KSynkConnection & );
    ~KSynkConnection();
    KSynkConnection &operator=( const KSynkConnection & );
    void setName( const QString& _newVal);
    const QString& getName() const;

    void setRemoteURL( const KURL& _newVal);
    const KURL& getRemoteURL() const;

    void setLocalURL( const KURL& _newVal);
    const KURL& getLocalURL() const;

    void setIgnoreModificationTime( bool ignore );
    bool ignoreModifcationTime() const ;

    bool isValid() const;

    /** Writes the connection to the specified KConfig object */
    void writeToConfig(KConfig* config);
    /** Reads all the settings for this connection from the specified KConfig object */
    void loadFromConfig(KConfig* config,const QString & name);

protected: // Protected attributes
    /** The remote url */
    KURL RemoteURL;
    /** The Connections Name */
    QString Name;
    /** The Local URL */
    KURL LocalURL;

    bool m_ignoreModificationTime;
};


#endif
