#
#  pykless.py (C) 2001 Jim Bublitz <jbublitz@nwinternet.com>
#
# derived from:
# * kless.cpp. Part of the KDE project.
# *
# * Copyright (C) 1998 Matthias Ettrich
# *
# */

from kdecore import KAccel, KStdAccel, KCmdLineArgs, KURL, KApplication, i18n, KAboutData,\
        BarIcon, NETRootInfo

from kdeui import KMainWindow, KMessageBox, KStdAction

from kfile import KFileDialog

from qt import QMultiLineEdit, QPopupMenu, QFile, QTextStream, QDir, SLOT, SIGNAL,\
        QString, IO_ReadOnly, QImage, QImageDrag, QTextDrag

import sys

FALSE = 0
TRUE  = not FALSE


TOOLBAR_EXIT = 0
TOOLBAR_OPEN = 1


class KLess(KMainWindow):
        def __init__ (self, *args):
                apply (KMainWindow.__init__, (self,) + args)
                self.edit = QMultiLineEdit(self)
                self.setCentralWidget(self.edit)
                self.setAcceptDrops(TRUE)

                p = QPopupMenu (self)

                #  // the easy KDE-1.0 way. Simply use Qt's menus for acceleration.
                #  // KStdAccel gives you access to the user's current settings. You
                #  // could as well write "CTRL+Key_N" instead of a.openNew(), but that
                #  // would not be configurable, of course.

                #a = KStdAccel ()
                #p.insertItem(i18n("&New Window"), self.slotNewWindow, a.openNew());
                #p.insertItem(i18n("&Load"), self.slotLoadFile, a.open());
                #p.insertSeparator();
                #p.insertItem(i18n("&Quit"), self.close, a.quit());

                ## ---- KStdAction ---
                # In the code below, File | Open is implemented using KStdAction
                # while the other File menu items use KStdAccel and 'insertItem'
                # 'openAction' has the same effect as the  related lines
                # which have been commented out for the menu and farther
                # down for self.toolBar)

                self.a = KAccel(self)
                self.a.connectItem(KStdAccel.New, self.slotNewWindow)
#                self.a.connectItem(KStdAccel.Open, self.slotLoadFile)
                kapp = KApplication.kApplication ()
                self.a.connectItem(KStdAccel.Quit, kapp.quit)

                # Another way to create menu item, toolbar button with accelerator, icon and menu icon
                openAction = KStdAction.open (self.slotLoadFile)
                print "self =", self

                id = p.insertItem(i18n("&New Window"), self.slotNewWindow)
                self.a.changeMenuAccel(p, id, KStdAccel.New)
                p.setItemEnabled (id, self.parent () == None)

                openAction.plug (p)    # Adds the 'Open' menu item

#                id = p.insertItem(i18n("&Open"), self.slotLoadFile)
#                self.a.changeMenuAccel(p, id, KStdAccel.Open)
                p.insertSeparator()
                id = p.insertItem(i18n("&Quit"), self.close)
                self.a.changeMenuAccel(p, id, KStdAccel.Quit)

                #// put the popupmenu as File-menu into the menu bar
                self.menuBar().insertItem(i18n("&File"), p)
                self.menuBar().insertSeparator()

                #// we let KDE generate a nifty help menu

                # You can uncomment the following lines if you don't want to
                # use KAboutData (see below) to generate the About dialog
                #p = self.helpMenu(i18n("kless --- the KDE text viewer :-) \n\n"
		#    "(c) 1998 Matthias Ettrich\n"
		#    "Demo Application for the K Desktop Environment.\n"
                #    "Modified by Jim Bublitz for PyKDE"))

                # Use KAboutData/KCmdLineArgs to generate the About dialog
                #            -- see below --
                # Comment this out if you want to generate the About dialog
                # information through 'helpMenu'

                p = self.helpMenu ("")

                self.menuBar().insertItem(i18n("&Help"), p)

                #//---------------------------------------------------
                #// build a small toolbar

                #// insert some buttons, the icons are from the standard KDE toolbar.

                openAction.plug (self.toolBar ())  # Adds button to toolbar (with connection)
#                self.toolBar().insertButton(BarIcon("fileopen.xpm"),TOOLBAR_OPEN, TRUE ,i18n("Open File"))

                #// Hint: toolBar() returns toolBar(0). If you want another toolbar, simply
                #//       use toolBar(1), toolBar(2) and so on.

                #// we connect the entire toolbar to one single slot. We could also
                #// connect the single toolbar buttons to special slots in the
                #// insertButton call above, for example:
                #//   insertButton(BarIcon("exit.xpm"),TOOLBAR_EXIT,
                #//                SIGNAL(clicked()), kapp, SLOT(quit()),
                #//                true,"Exit")
                #// This would be even better for this simple toolbar. We have chosen
                #// the other design --- which is more flexible for bigger toolbars ---
                #// for demonstration purposes in kless.

#                self.connect(self.toolBar(), SIGNAL("clicked(int)"), self.slotToolbarClicked)



#        def slotToolbarClicked(self, item):
#               if item == TOOLBAR_OPEN:
#                        self.slotLoadFile()

        def loadFile(self, filename):
        #// load a file from a filename
                self.edit.clear ()

                print "Filename:", filename.path ()

                f = QFile (filename.path ())
                if f.open(IO_ReadOnly):
                        t = QTextStream (f)
                        while (not t.eof()):
                                self.edit.append (t.readLine ())
                f.close()

        def dropEvent(self, event):
        #  #// the user dropped something on our window.
        #  // So we simply use KIO slaves to download the stuff wherever it is.
        #  // The following code respects Qt's DnD tutorial
                print "drop event"

                im = QImage ()
                txt = QString ()
                u   = QString ()
                uri = []

                if QImageDrag.decode(event, im):
                        KMessageBox.sorry(this, i18n("This application accepts only URL drops"))

                if QTextDrag.decode(event, txt):
                        print "text"
                        setCaption("The KDE text viewer")
                        self.edit.setText(txt)

                if QUriDrag.decode(event, uri):
                        u = uri [0]
                        print "uri", u
                        loadFile(u)

        def slotNewWindow(self):
                #// this slot is invoked from File->New_Window
                w = KLess (self, "child")
                w.show()
                self.show ()

        def slotLoadFile(self):
                #// this slot is invoked from File->Open

                #// ask kfiledialog for a filename. We pass "this" to the function
                #// to indicate the window manager that the file dialog belongs
                #// to our application window.
                u = KFileDialog.getOpenURL(QString.null,     # initial dir
                                    QString.null,              # filter
                                    self)

                if not u.isEmpty():
                        self.loadFile(u)


        def queryClose(self):
                res = KMessageBox.warningYesNoCancel(self,\
                        i18n("Save changes to Document?<br>(Does not make sense, we know, but it is just a programming example :-)"))
                if res == KMessageBox.Yes:
	        #// save document here. If saving fails, return FALSE
	                return TRUE

                elif res == KMessageBox.No:
                        return TRUE

                else: #// cancel
	                return FALSE

        def queryExit(self):
                #// this slot is invoked in addition when the *last* window is going
                #// to be closed. We could do some final cleanup here.
                return TRUE #// accept

#// Session management: save data
        def saveProperties(self, config):
  #// This is provided just as an example.
  #// It is generally not so good to save the raw contents of an application
  #//  in its configuration file (as this example does).
  #// It is preferable to save the contents in a file on the application's
  #//  data zone and save an URL to it in the configuration resource.
                config.writeEntry("text", self.edit.text())


#// Session management: read data again
        def readProperties(self, config):
  #// See above
                self.edit.setText(config.readEntry("text"))


#-------------------- main ------------------------------------------------

	#// A Human readable description of your program
#description = i18n("KLess- Less is More")
description = "KLess- Less is More"
	#// The version
version = "1.0py"


#int main(int argc, char* argv[]) {

aboutData = KAboutData ("kless", "KLess",\
    version, description, KAboutData.License_GPL,\
    "(c) 1998, Matthias Ettrich")

aboutData.addAuthor ("Matthias Ettrich", "Original C++ kless", "ettrich@kde.org")
aboutData.addAuthor ("Jim Bublitz", "Adapted for PyKDE", "jbublitz@nwinternet.com")

KCmdLineArgs.init1 (sys.argv, aboutData)

KCmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = KApplication ()

if (app.isRestored()):
        RESTORE(KLess)
else:
    #// no session management: just create one window
        kless = KLess (None, "kless")
        if len(sys.argv) > 1:
                #// read kcmdlineargs.h for the full unabridged instructions
                #// on using KCmdLineArgs, it's pretty confusing at first, but it works
                args = KCmdLineArgs.parsedArgs()
#                print "Args:", args
#                print str(QDir.currentDirPath ()) + "/"
#                print sys.argv [0]

                url = str(QDir.currentDirPath()) + "/" + sys.argv [0];

                kless.loadFile(KURL(url))

kless.show()
app.exec_loop()
