#
#       Tests for dcop module - Copyright 2001 Jim Bublitz <jbublitz@nwinternet.com>
#

from dcop import DCOPClient
from kdeui import KDialogBase, KEdit
from qt import QLabel, SIGNAL

FALSE = 0
TRUE = not FALSE

class testDCOPClient (KDialogBase):
        def __init__ (self, parent, dcopclient):
                KDialogBase.__init__ (self, parent, None, TRUE, "Test DCOPClient",
                        KDialogBase.Close | KDialogBase.User1, KDialogBase.Close, FALSE, "Test")

                self.setMinimumSize (500, 500)
                self.dcopclient = dcopclient
                vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", vbox)
                self.ked = KEdit (vbox)

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testDCOPClient)

        def testDCOPClient (self):
                self.ked.clear ()
                self.ked.insertLine ("Testing DCOPClient...")
                self.ked.insertLine ("")

                ok = self.dcopclient.attach ()
                if not ok:
                        self.ked.insertLine ("Couldn't attach to DCOP server")
                        self.ked.insertLine ("")
                        return

                self.ked.insertLine ("     registeredApplications ()")
                self.ked.insertLine ("===================================")
                self.ked.insertLine ("")

                result1 = self.dcopclient.registeredApplications ()
                print result1

                for item in result1:
                        print item

                if result1 == []:
                        self.ked.insertLine ("<empty list>")
                        self.ked.insertLine ("... Can't run other tests")
                        return
                else:
                        for item in result1:
                                self.ked.insertLine (str(item))
                self.ked.insertLine ("")



                self.ked.insertLine ("     remoteObjects (" + str(result1[0]) + ")")
                self.ked.insertLine ("======================================")
                self.ked.insertLine ("")

                result2 = self.dcopclient.remoteObjects (result1 [0])
                print result2

                if result2 [0] == []:
                        self.ked.insertLine ("<empty list>")
                elif not result2 [1]:
                        self.ked.insertLine ("remoteObjects returned not ok")
                else:
                        self.ked.insertLine ("remoteObjects returned 'ok'")
                        self.ked.insertLine ("")
                        for item in result2 [0]:
                                self.ked.insertLine (str(item))
                self.ked.insertLine ("")



                self.ked.insertLine ("     remoteInterfaces (" + str(result1 [0]) + "," + str(result2 [0][0]) + ")")
                self.ked.insertLine ("==================================================")
                self.ked.insertLine ("")

                result = self.dcopclient.remoteInterfaces (result1 [0], result2 [0][0])
                print result

                if result [0] == []:
                        self.ked.insertLine ("<empty list>")
                elif not result [1]:
                        self.ked.insertLine ("remoteInterfaces returned not ok")
                else:
                        self.ked.insertLine ("remoteInterfaces returned 'ok'")
                        self.ked.insertLine ("")
                        for item in result [0]:
                                self.ked.insertLine (str(item))
                self.ked.insertLine ("")



                self.ked.insertLine ("     remoteFunctions (" + str(result1 [0]) + "," + str(result2 [0][0]) + ")")
                self.ked.insertLine ("==================================================")
                self.ked.insertLine ("")

                result = self.dcopclient.remoteFunctions (result1 [0], result2 [0][0])
                print result

                if result [0] == []:
                        self.ked.insertLine ("<empty list>")
                elif not result [1]:
                        self.ked.insertLine ("remoteFunctions returned not ok")
                else:
                        self.ked.insertLine ("remoteFunctions returned 'ok'")
                        self.ked.insertLine ("")
                        for item in result [0]:
                                self.ked.insertLine (str(item))
                self.ked.insertLine ("")
