// Qt includes
#include <qstring.h>
#include <qfile.h>

// KDE includes
#include <klocale.h>

// KMtraceViewer includes
#include "KMtraceSourceCodeView.hh"
#include "KMtraceSourceCodeView.moc"

KMtraceSourceCodeView::KMtraceSourceCodeView( QWidget *parent )
  : KEdit( parent )
{
   setReadOnly( TRUE );
   setTextFormat( Qt::PlainText );
}

void KMtraceSourceCodeView::slotModuleChanged( QString module, int line )
{
   QFile f( module );   
   if( f.open( IO_ReadOnly ) ) {
       // read in source file and set it as text for the viewer
       QTextStream t( &f );
       setText( t.read( ) );
       f.close( );

       // make sure the text is rendered so we can set the cursor
       // position and selection! (see bug #2)
       // (he sync method seems not to be documented!)
       sync( );
       
       // try to mark the line with the leak
       setCursorPosition( line-1, 0 );
       setSelection( line-1, 0, line-1, width( ) );
       ensureCursorVisible( );
   }
}

void KMtraceSourceCodeView::slotModuleUnselect( )
{
   setText( i18n( "No source code available!" ) );
}
