/***************************************************************************
                          dockwidget.h  -  description
                             -------------------
    begin                : Fri Nov 14 2000
    copyright            : (C) 2000 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qstringlist.h>
#include <ksystemtray.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef DOCKWIDGET_H
#define DOCKWIDGET_H


#define MENU_DIALOG_ID 101
#define MENU_UNDOCK_ID 102
#define MENU_WATCH_ID  103
#define MENU_CONFIG_ID 104
#define MENU_EXIT_ID   105

class KPopupFrame;
class KPopupMenu;
class QTextView;

/**
  *@author Michael Heidecke
  */

class dockwidget : public KSystemTray
{
  Q_OBJECT
  public:
	dockwidget(QWidget * parent=0, const char * name=0);
	~dockwidget();

	KPopupFrame *mypop;  		/* popup window frame */
	QTextView *myview;   		/* popup dsiplay */
	bool _fPopup; 			/* false = popup at cursor */
	QStringList strHistory;		/* history (popup menu) */

	void getTranslation(const QString &szWord);

 public slots:
	void slotMenuClicked(int);

 signals:
	void undock(void);
	void done(void);
	void configure(void);
	void translate( const QString & );
	void toggleWatchCb(void);

 protected:
	void mousePressEvent(QMouseEvent *e);

 private:
	KPopupMenu *popup_menu;
    void execPopup(void);
    void translate(int n);
    void quickDialog(void);
};
#endif
