/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qregexp.h>

// command includes
#include "filterlistcommand.h"
#include "filterlistwidget.h"

using namespace WorKflow;

FilterListCommand::FilterListCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  FilterListWidget* w = new FilterListWidget(this);
  setWidget(w);
}

FilterListCommand::~FilterListCommand()
{
}

void FilterListCommand::execute()
{
  QStringList list = value("input").asStringList();
  QStringList res;

  bool casesens = value("casesensitive").nextBoolean();
  bool invert = value("invert").nextBoolean();

  if (value("regexp").nextBoolean()) {
    QRegExp rx(value("filter").nextString(), casesens);
    res = list.grep(rx);
  } else {
    QString filter = value("filter").nextString();
    res = list.grep(filter, casesens);
  }

  setResult("output", Value::stringList("org.kde.public.anything", res));
}

#include "filterlistcommand.moc"
