/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWRUNTIMEINFO_H
#define WORKFLOWRUNTIMEINFO_H

#include <qobject.h>

// forward declarations
namespace WorKflow
{
  class Service;
  class Document;
}

namespace WorKflow
{
  /**
   * @author Thomas Kadauke <tkadauke@gmx.de>
   */
  class ServiceInfo : public QObject
  {
    Q_OBJECT

  public:
    typedef QValueList<Service*> List;

    ServiceInfo(Document* doc);
    ~ServiceInfo();

    List query(int position, const QString& type);

  private:
    Document* m_document;
  };
}

#endif
