/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qpainter.h>

// WorKflow includes
#include "commandcounter.h"

using namespace WorKflow;

CommandCounter::CommandCounter(QWidget* parent, const char* name)
  : CornerWidget(parent, name), m_row(0)
{
}

CommandCounter::~CommandCounter()
{
}

void CommandCounter::paintEvent(QPaintEvent*)
{
  QPainter p(this);

  drawBackground(&p, true);
  drawInner(&p, Qt::white);
  drawText(&p, text());
}

void CommandCounter::setOrder(int row)
{
  m_row = row;
  update();
}

QString CommandCounter::text()
{
  return QString("%1").arg(m_row + 1);
}

int CommandCounter::row()
{
  return m_row;
}

void CommandCounter::mousePressEvent(QMouseEvent* e)
{
  if (e->button() & (Qt::LeftButton | Qt::RightButton)) {
    emit popup(e->globalPos());
  }
}

#include "commandcounter.moc"
