/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWVIEW_H
#define WORKFLOWVIEW_H

// Qt includes
#include <qscrollview.h>
#include <qmap.h>

// WorKflow includes
// #include <workflowiface.h>

// forward declarations
class KURL;
class QPainter;
class QVBoxLayout;

namespace WorKflow
{
  class Document;
  class Command;
  class CommandWidget;
}

namespace WorKflow
{
  /**
   * This is the main view class for WorKflow.  Most of the non-menu,
   * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
   * here.
   *
   * This workflow uses an HTML component as an example.
   *
   * @short Main view
   * @author Thomas Kadauke <tkadauke@gmx.de>
   */
  class View : public QScrollView   //, public WorKflowIface
  {
    Q_OBJECT
  public:
    /**
      * Default constructor
      */
    View(QWidget *parent);

    /**
     * Creates a new View with an existing document.
     * @param parent The parent widget.
     * @param doc The document to use.
     */
    View(QWidget* parent, Document* doc);

    /**
      * Destructor
      */
    virtual ~View();

    /**
      * Random 'get' function
      */
    QString currentURL();

    /**
      * Random 'set' function accessed by DCOP
      */
    virtual void openURL(QString url);

    /**
      * Random 'set' function
      */
    virtual void openURL(const KURL& url);

    bool hasSelection();

    Document* document();

  public slots:
    void appendCommand(const QString& commandId);
    void copy();
    void cut();
    void paste();

    void clearSelection();
    void selectAll();

    void collapseAll();
    void uncollapseAll();

    void execute();

  signals:
    /**
      * Use this signal to change the content of the statusbar
      */
    void signalChangeStatusbar(const QString& text);

    /**
      * Use this signal to change the content of the caption
      */
    void signalChangeCaption(const QString& text);

    void selectionChanged();

  protected slots:
    void calculateLayout();
    void newCommand(Command* cmd);

  protected:
    void init();
    void initDocument();
    void initDragHint();

    virtual void drawContents(QPainter* p, int clipx, int clipy, int clipw, int cliph);
    virtual void contentsMousePressEvent(QMouseEvent* e);
    virtual void contentsMouseReleaseEvent(QMouseEvent* e);
    virtual void contentsMouseMoveEvent(QMouseEvent* e);
    virtual void contentsDragEnterEvent(QDragEnterEvent* e);
    virtual void contentsDragMoveEvent(QDragMoveEvent* e);
    virtual void contentsDragLeaveEvent(QDragLeaveEvent*);
    virtual void contentsDropEvent(QDropEvent* e);
  //   virtual void contentsContextMenuEvent(QContextMenuEvent* e);
    virtual void viewportResizeEvent(QResizeEvent*);
    virtual void keyPressEvent(QKeyEvent* e);
    virtual void focusInEvent(QFocusEvent*);
    virtual void focusOutEvent(QFocusEvent*);

    void moveCursor(int deltarow, bool select);
    void goToStart(bool select);
    void goToEnd(bool select);
    void setCursor(QPoint position);

    void calculateSelection();

    void deletePressed();
    void backspacePressed();
    void removeSelection();

  public:
    class Private;

  private:
    friend class Private;
    class Cursor;
    class Selection;
    Private* d;
  };
}

#endif // _WORKFLOWVIEW_H_
