// This file is generated by kconfig_compiler from ipv6.kcfg.
// All changes you do to this file will be lost.

#include "ipv6persistence.h"

using namespace Knm;

Ipv6Persistence::Ipv6Persistence(Ipv6Setting * setting, KSharedConfig::Ptr config, SettingPersistence::SecretStorageMode mode) : SettingPersistence(setting, config, mode)
{
}

Ipv6Persistence::~Ipv6Persistence()
{
}

void Ipv6Persistence::load()
{
  Ipv6Setting * setting = static_cast<Ipv6Setting *>(m_setting);
  {
    QString contents = m_config->readEntry("method", "Ignore");
    if (contents == "Automatic")
      setting->setMethod(Ipv6Setting::EnumMethod::Automatic);
    else     if (contents == "LinkLocal")
      setting->setMethod(Ipv6Setting::EnumMethod::LinkLocal);
    else     if (contents == "Manual")
      setting->setMethod(Ipv6Setting::EnumMethod::Manual);
    else     if (contents == "Shared")
      setting->setMethod(Ipv6Setting::EnumMethod::Shared);
    else     if (contents == "Ignore")
      setting->setMethod(Ipv6Setting::EnumMethod::Ignore);
  }

  // dns
  QList<QHostAddress> dnsServers;
  QStringList rawDnsServers = m_config->readEntry("dns", QStringList());
  foreach (const QString &server, rawDnsServers) {
      dnsServers.append(QHostAddress(server));
  }
  setting->setDns(dnsServers);

  setting->setDnssearch(m_config->readEntry("dnssearch", QStringList()));

  // addresses
  QList<Solid::Control::IPv6Address> addresses;
  QStringList rawAddresses = m_config->readEntry("addresses", QStringList());
  foreach (const QString &rawAddress, rawAddresses) {
      QStringList parts = rawAddress.split(';');
      if (parts.count() != 3) { // sanity check
          continue;
      }
      QHostAddress ip(parts[0]);
      QHostAddress gateway(parts[2]);
      Solid::Control::IPv6Address addr(ip.toIPv6Address(), parts[1].toUInt(), gateway.toIPv6Address());
      addresses.append(addr);
  }
  setting->setAddresses(addresses);

  // routes
  QList<Solid::Control::IPv6Route> routes;
  QStringList rawRoutes = m_config->readEntry("routes", QStringList());
  foreach (const QString &rawRoute, rawRoutes) {
      QStringList parts = rawRoute.split(';');
      if (parts.count() != 4) { // sanity check
          continue;
      }
      QHostAddress address(parts[0]);
      quint32 prefix = parts[1].toUInt();
      QHostAddress nextHop(parts[2]);
      quint32 metric = parts[3].toUInt();
      Solid::Control::IPv6Route route(address.toIPv6Address(), prefix, nextHop.toIPv6Address(), metric);
      routes.append(route);
  }
  setting->setRoutes(routes);
  setting->setIgnoredhcpdns(m_config->readEntry("ignoredhcpdns", false));
  setting->setIgnoreautoroute(m_config->readEntry("ignoreautoroute", false));
  setting->setNeverdefault(m_config->readEntry("neverdefault", false));
  setting->setMayfail(m_config->readEntry("mayfail", true));
}
