/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"
#include "skgreportbank.h"
#include "skgimportplugin.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);
    {
        // Test bug 324649
        SKGDocumentBank document1;
        SKGTESTERROR("document1.load()", document1.load(SKGTest::getTestPath("IN") % "/skgtestvariousbugs/324649.skg"), true);

        // Check
        {
            SKGReportBank* report = static_cast<SKGReportBank*>(document1.getReport());
            report->setPeriod("2013-09");

            QVariantList values = report->getBankTable();
            SKGTEST("324649:getCurrentAmount", values.count(), 4);
            SKGTEST("324649:title", values[0].toList()[0].toString(), "sum");
            SKGTEST("324649:10", values[1].toList()[2].toString(), "20");
            SKGTEST("324649:20", values[2].toList()[2].toString(), "10");
            SKGTEST("324649:30", values[3].toList()[2].toString(), "30");
        }
    }

    {
        // Test bug 324972
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_CSV", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestvariousbugs/324972_1.csv"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }

        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_CSV", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestvariousbugs/324972_2.csv"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);

            QList<SKGDocument::SKGMessage> messages;
            SKGTESTERROR("DOC.getMessages", document1.getMessages(document1.getCurrentTransaction(), messages, true), true);
            bool test = false;
            foreach(const SKGDocument::SKGMessage & msg, messages) {
                SKGTRACE << "Message:" << msg.Text << endl;
                if (msg.Text.contains("last imported one")) {
                    test = true;
                }
            }
            SKGTEST("message.last imported one", static_cast<unsigned int>(test), 1);
        }


        SKGAccountObject account;
        SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "My account", account), true);
        SKGTESTERROR("ACCOUNT.load", account.load(), true);
        SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1000");
    }


    {
        // Test import Weboob
        SKGDocumentBank document1;
        SKGTESTERROR("document1.load()", document1.load(SKGTest::getTestPath("IN") % "/skgtestvariousbugs/interests_and_shares.skg"), true);

        // Check
        {
            SKGAccountObject act(&document1);
            SKGTESTERROR("account.setName()", act.setName("TEST"), true);
            SKGTESTERROR("account.load()", act.load(), true);

            QList<SKGAccountObject::SKGInterestItem> oInterestList;
            double oInterests;
            SKGTESTERROR("account.getInterestItems()", act.getInterestItems(oInterestList, oInterests, 2013), true);
            SKGTEST("oInterestList", oInterestList.count(), 4);
            SKGTEST("oInterests", static_cast<unsigned int>(oInterests > 3.20 && oInterests < 3.22), 1);
        }
    }

    {
        // Test open invalid files
        SKGDocumentBank document1;
        SKGTEST("document1.load(interests_and_shares.skg,notneededpassword)", document1.load(SKGTest::getTestPath("IN") % "/skgtestvariousbugs/interests_and_shares.skg", "notneededpassword").getReturnCode(), 0);
        SKGTEST("document1.load(invalid.skg)", document1.load(SKGTest::getTestPath("IN") % "/skgtestvariousbugs/invalid.skg").getReturnCode(), ERR_CORRUPTION);
        SKGTEST("document1.load(invalid_protected.skg)", document1.load(SKGTest::getTestPath("IN") % "/skgtestvariousbugs/invalid_protected.skg").getReturnCode(), ERR_ENCRYPTION);
        SKGTEST("document1.load(protected.skg)", document1.load(SKGTest::getTestPath("IN") % "/skgtestvariousbugs/protected.skg").getReturnCode(), ERR_ENCRYPTION);
        SKGTEST("document1.load(protected.skg, pwd)", document1.load(SKGTest::getTestPath("IN") % "/skgtestvariousbugs/protected.skg", "pwd").getReturnCode(), 0);

        SKGTEST("document1.load(forrecovery.skg)", document1.load(SKGTest::getTestPath("OUT") % "/skgtestvariousbugs/forrecovery.skg").getReturnCode(), ERR_CORRUPTION);
        QString recoveredFile;
        SKGTESTERROR("document1.recover(forrecovery.skg)", document1.recover(SKGTest::getTestPath("OUT") % "/skgtestvariousbugs/forrecovery.skg", "", recoveredFile), true);
        SKGTEST("document1.load(forrecovery_recovered.skg)", document1.load(recoveredFile).getReturnCode(), 0);
    }

    {
        // Test 329568
        SKGDocumentBank document1;
        SKGTESTERROR("document1.load()", document1.load(SKGTest::getTestPath("IN") % "/skgtestvariousbugs/329568.skg"), true);

        // Check
        {
            SKGAccountObject act(&document1);
            SKGTESTERROR("account.setName()", act.setName("T"), true);
            SKGTESTERROR("account.load()", act.load(), true);

            QList<SKGAccountObject::SKGInterestItem> oInterestList;
            double oInterests;
            SKGTESTERROR("account.getInterestItems()", act.getInterestItems(oInterestList, oInterests, 2014), true);
            SKGTEST("oInterestList", oInterestList.count(), 4);
            SKGTEST("oInterests", static_cast<unsigned int>(oInterests > 8.20 && oInterests < 8.22), 1);
        }

        {
            SKGImportPlugin* imp1 = new SKGImportPlugin();
            SKGTESTERROR("SKGImportPlugin.importFile", imp1->importFile(), false);
            SKGTESTERROR("SKGImportPlugin.exportFile", imp1->exportFile(), false);
            imp1->getMimeTypeFilter();
            delete imp1;
        }
    }
    // End test
    SKGENDTEST();
}
