/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"


/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);

    // test class SKGDocument / PARAMETERS
    SKGDocument document1;
    SKGTESTERROR("PARAM:initialize", document1.initialize(), true);
    SKGTESTERROR("PARAM:beginTransaction", document1.beginTransaction("t1"), true);
    SKGTESTERROR("PARAM:setParameter", document1.setParameter("ATT1", "VAL1"), true);
    SKGTESTERROR("PARAM:endTransaction", document1.endTransaction(true), true);
    SKGTEST("PARAM:getCachedValue", document1.getCachedValue("NOTFOUND"), "");

    SKGDocument document2;
    SKGTESTERROR("PARAM:initialize", document2.initialize(), true);
    SKGTESTERROR("PARAM:beginTransaction", document2.beginTransaction("t2"), true);
    SKGTESTERROR("PARAM:setParameter", document2.setParameter("ATT2", "VAL2"), true);
    SKGTESTERROR("PARAM:setParameter", document2.setParameter("ATT3", "dates.txt", SKGTest::getTestPath("IN") % "/dates.txt"), true);
    SKGTESTERROR("PARAM:endTransaction", document2.endTransaction(true), true);


    SKGTEST("PARAM:getParameter", document1.getParameter("ATT1"), "VAL1");
    SKGTEST("PARAM:getParameter", document2.getParameter("ATT2"), "VAL2");

    SKGTEST("PARAM:getFileExtension", document2.getFileExtension(), "skgc");

    document1.formatPercentage(1.1, true);
    document1.formatPercentage(1.1, false);
    SKGTEST("PARAM:getRealAttribute", document2.getRealAttribute("t_ATT"), "");
    SKGTEST("PARAM:getRealAttribute", document2.getRealAttribute("t_att"), "t_att");

    document1.getDatabaseIdentifier();
    document1.getParameters("document", "t_name like 'ATT%'");

    // Special SQL command
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSqliteOrder("SELECT * FROM (SELECT CAPITALIZE(LOWER(UPPER(WORD('Abc Def', 2)))) AS V) WHERE REGEXP('D.*', V) OR WILDCARD('D*', V)"), true);
    QString result;
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT TODATE('07162013', 'MMDDYYYY')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-TODATE", result, "2013-07-16");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT TODATE('ABCDEFGHIJ', 'MMDDYYYY')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-TODATE", result, SKGServices::dateToSqlString(QDate::currentDate()));
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('Abc Def Ghi', 0)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Abc");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('Abc Def Ghi', 1)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Abc");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('Abc Def Ghi', 2)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Def");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('Abc Def Ghi', 3)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Ghi");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('Abc Def Ghi', 99)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Ghi");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('Abc Def Ghi', -99)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Abc");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('Abc Def Ghi', -3)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Abc");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('Abc Def Ghi', -2)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Def");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('Abc Def Ghi', -1)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Ghi");

    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('   Abc    Def   Ghi ', 1)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Abc");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('   Abc    Def   Ghi ', 2)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Def");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT WORD('   Abc    Def   Ghi ', 3)", result), true);
    SKGTEST("PARAM:executeSqliteOrder-WORD", result, "Ghi");

    QMap<QString, QVariant> map;
    map[":2"] = "20";
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSqliteOrder("SELECT WORD('Abc Def', :2)", map), true);

    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT TOCURRENCY(1234, 'F')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-1234 F", result, "F 1,234.00");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT TOCURRENCY(-1234, (SELECT 'F'))", result), true);
    SKGTEST("PARAM:executeSqliteOrder-1234 F", result, "F -1,234.00");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD((SELECT '2013-03-05'), (SELECT 'D'))", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD D", result, "2013-03-05");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2013-03-05', 'W')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD W", result, "2013-W10");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2013-03-05', 'M')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD M", result, "2013-03");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2013-03-05', 'Q')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD Q", result, "2013-Q1");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2013-03-05', 'S')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD S", result, "2013-S1");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2013-03-05', 'Y')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD Y", result, "2013");

    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2014-07-16', 'D')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD D", result, "2014-07-16");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2014-07-16', 'W')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD W", result, "2014-W29");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2014-07-16', 'M')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD M", result, "2014-07");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2014-07-16', 'Q')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD Q", result, "2014-Q3");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2014-07-16', 'S')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD S", result, "2014-S2");
    SKGTESTERROR("PARAM:executeSqliteOrder", document1.executeSingleSelectSqliteOrder("SELECT PERIOD('2014-07-16', 'Y')", result), true);
    SKGTEST("PARAM:executeSqliteOrder-PERIOD Y", result, "2014");
    // End test
    SKGENDTEST();
}
